﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.ModelsEnumTypes;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class ProviderCredentialsMap
    {
        public static async Task<IQueryable<ProviderCredential>> MapProviderCredentials(List<ppms_providercredential> ppmsProvidercredentials, string mapRelatedType, PpmsContext context)
        {
            var providerCredentials = new List<ProviderCredential> {};
            foreach (var ppmsProviderCredential in ppmsProvidercredentials)
            {                
                    var providerCredential = new ProviderCredential
                    {
                        CredentialNumber = (int)ppmsProviderCredential.ppms_credentialnumber,
                        Name = ppmsProviderCredential.ppms_name,
                        Description = ppmsProviderCredential.ppms_Description, 
                    };

                    //Switch for Credential Status 
                    if (ppmsProviderCredential.ppms_credentialingstatus != null)
                        switch (ppmsProviderCredential.ppms_credentialingstatus.Value)
                        {
                            case (int)ppms_providercredential_ppms_credentialingstatus.Active:
                                providerCredential.CredentialSatus = CredentialStatus.Active;
                                break;
                            case (int)ppms_providercredential_ppms_credentialingstatus.Inactive:
                                providerCredential.CredentialSatus = CredentialStatus.Inactive;
                                break;
                            case (int)ppms_providercredential_ppms_credentialingstatus.Suspended:
                                providerCredential.CredentialSatus = CredentialStatus.Suspended;
                                break;
                            case (int)ppms_providercredential_ppms_credentialingstatus.Revoked:
                                providerCredential.CredentialSatus = CredentialStatus.Revoked;
                                break;
                        }

                    //Switch for Credential Type 
                    if (ppmsProviderCredential.ppms_credentialtype != null)
                        switch (ppmsProviderCredential.ppms_credentialtype.Value)
                        {
                            case (int)ppms_providercredential_ppms_credentialtype.Individual:
                                providerCredential.CredentialType = CredentialType.Individual;
                                break;
                            case (int)ppms_providercredential_ppms_credentialtype.Organization:
                                providerCredential.CredentialType = CredentialType.Organization;
                                break;
                        }

                    //Check for null & populate the Date fields here. 
                    if (ppmsProviderCredential.ppms_credentialeddate != null){providerCredential.CredentialedDate = ppmsProviderCredential.ppms_credentialeddate.ToString();}
                    if (ppmsProviderCredential.ppms_nextcredentialingdate != null) { providerCredential.NextCredentialingDate = ppmsProviderCredential.ppms_nextcredentialingdate.ToString(); }

                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";

                //Map Related Types
                switch (mapRelatedType)
                {
                    case "Provider":
                        //Lookup and Map the Provider
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderCredential.ppms_ProviderId.Id);
                        var ppmsProvidersList = new List<Account> { ppmsProvider };
                        providerCredential.Provider =
                            await ProviderMap.MapProviders(ppmsProvidersList, "None");
                        break;
                    default:
                        break;
                }

                providerCredentials.Add(providerCredential);               
            }
            return providerCredentials.AsQueryable();            
        }

       
    }
}